#include <QtGui>

#include "Highlighter.h"

Highlighter::Highlighter(QTextDocument *parent) : QSyntaxHighlighter(parent)
{
	HighlightingRule rule;
	
	keywordFormat.setForeground(Qt::blue);
	QStringList keywordPatterns;

	this->MakeKeywordList(keywordPatterns);
	
	foreach (QString pattern, keywordPatterns){
		rule.pattern = QRegExp(pattern);
		rule.pattern.setCaseSensitivity(Qt::CaseInsensitive);
		rule.format = keywordFormat;
		highlightingRules.append(rule);
	}

	keywordFormat.setForeground(Qt::darkCyan);
	QStringList dataTypePatterns;

	this->MakeDataTypeList(dataTypePatterns);

	foreach (QString pattern, dataTypePatterns) {
		rule.pattern = QRegExp(pattern);
		rule.pattern.setCaseSensitivity(Qt::CaseInsensitive);
		rule.format = keywordFormat;
		highlightingRules.append(rule);
	}

	parenthesisFormat1.setForeground(Qt::darkRed);
	rule.pattern = QRegExp("\\(");
    rule.format = parenthesisFormat1;
    highlightingRules.append(rule);

	parenthesisFormat2.setForeground(Qt::darkRed);
	rule.pattern = QRegExp("\\)");
    rule.format = parenthesisFormat2;
    highlightingRules.append(rule);	

	singleLineCommentFormat.setForeground(Qt::darkGreen);
	singleLineCommentFormat.setFontItalic(true);
    rule.pattern = QRegExp("//[^\n]*");
    rule.format = singleLineCommentFormat;
    highlightingRules.append(rule);

	quotationFormat.setForeground(Qt::red);
    rule.pattern = QRegExp("\".*\"");
    rule.format = quotationFormat;
    highlightingRules.append(rule);

	quotationFormat.setForeground(Qt::red);
    rule.pattern = QRegExp("\'.*\'");
    rule.format = quotationFormat;
    highlightingRules.append(rule);

	quotationFormat.setForeground(Qt::red);
    rule.pattern = QRegExp("`.*`");
    rule.format = quotationFormat;
    highlightingRules.append(rule);

	quotationFormat.setForeground(Qt::magenta);
    rule.pattern = QRegExp("\\[");
    rule.format = quotationFormat;
    highlightingRules.append(rule);

	quotationFormat.setForeground(Qt::magenta);
    rule.pattern = QRegExp("\\]");
    rule.format = quotationFormat;
    highlightingRules.append(rule);

	multiLineCommentFormat.setFontItalic(true);
	multiLineCommentFormat.setForeground(Qt::darkGreen);
	commentStartExpression = QRegExp("/\\*");
	commentEndExpression = QRegExp("\\*/");
 }

void Highlighter::MakeKeywordList(QStringList& keywordPatterns)
{
	keywordPatterns  << "\\bTABLE\\b" << "\\bINSERT\\b" << "\\bVALUES\\b"<< "\\bUPDATE\\b"
		<< "\\bCREATE\\b"<< "\\bDELETE\\b" << "\\bLOW_PRIORITY\\b" << "\\bQUICK\\b"
		<< "\\bFROM\\b"  << "\\bWHERE\\b"  << "\\bLIMIT\\b"<< "\\bIGNORE\\b"
		<< "\\bINTO\\b"  << "\\bSELECT\\b" << "\\bHIGH_PRIORITY\\b"  <<"\\bSET\\b"
		<< "\\bVALUES\\b"<< "\\bREPLACE\\b"<< "\\bTRUNCATE\\b" << "\\bON\\b"
		<< "\\GROUP\\b" << "\\bORDER\\b" <<"\\bALTER\\b" <<"\\bDATABASE\\b"
		<<"\\bDEFAULT\\b" <<"\\bCHARACTER\\b" <<"\\bCOLLATE\\b" <<"\\bSHOW\\b"
		<<"\\bPROCEDURE\\b" <<"\\bVIEW\\b" <<"\\bDATABASES\\b" <<"\\bFUNCTION\\b"
		<<"\\bSTATUS\\b" <<"\\bLIKE\\b" <<"\\bJOIN\\b"  <<"\\bLEFT\\b" <<"\\bOUTER\\b"
		<<"\\bRIGHT\\b" <<"\\bDUPLICATE\\b" <<"\\bKEY\\b" <<"\\bDELAYED\\b"
		<<"\\bDECLARE\\b" <<"\\bCONDITION" <<"\\bFOR\\b" << "\\bSQLSTATE\\b"
		<<"\\bSQLWARNING\\b" <<"\\bCASE\\b" <<"\\bWHEN\\b" <<"\\bTHEN\\b" <<"\\bELSE\\b"
		<<"\\bEND\\b" <<"\\bELSEIF\\b" <<"\\bIF\\b" <<"\\bITERATE\\b" <<"\\bEND\\b"  
		<<"\\bLOOP\\b" <<"\\bLEAVE\\b" <<"\\bREPEAT\\b" <<"\\bUNTIL\\b" <<"\\bWHILE\\b"
		<<"\\bDO\\b" <<"\\bCLOSE\\b" <<"\\bFULL\\b" <<"\\bUNION\\b" <<"\\bHANDLER\\b" 
		<<"\\bCURSOR\\b" <<"\\bFETCH\\b" <<"\\bOPEN\\b" <<"\\bEVENT\\b" <<"\\bSCHEDULE\\b"
		<<"\\bEVERY\\b" <<"\\bHOUR\\b"  <<"\\bSTARTS\\b" <<"\\bCURRENT_TIMESTAMP\\b"
		<<"\\bENABLE\\b" <<"\\bEXISTS\\b" <<"\\bAT\\b" <<"\\bCOMPLETION\\b" <<"\\bNOT\\b"
		<<"\\bPRESERVE\\b" <<"\\bDISABLE\\b" <<"\\bCOMMENT\\b" <<"\\bDROP\\b" 
		<<"\\bCONTAINS\\b" <<"\\bSQL\\b" <<"\\bROUTINE\\b" <<"\\bSECURITY\\b"
		<<"\\bDEFINER\\b"  <<"\\bRETURNS\\b" <<"\\bRETURNS\\b" <<"\\bIN\\b" <<"\\bBEGIN\\b"  
		<<"\\bADD\\b" <<"\\bINDEX\\b" <<"\\bNULL\\b" <<"\\bAUTO_INCREMENT\\b" <<"\\bTYPE\\b"
		<<"\\bINSERT_METHOD\\b" <<"\\bPRIMARY\\b" <<"\\bCASCADE\\b" <<"\\bTRIGGER\\b" 
		<<"\\bAS\\b" <<"\\bALGORITHM\\b" <<"\\bUNDEFINED\\b"  << "\\bCOLUMN\\b" << "\\bTABLE\\b"
		<< "\\bvalue\\b" << "\\bDatabase\\b" << "\\bprocedure\\b" << "\\bfunction\\b"
		<< "\\bCURSOR\\b" << "\\buser\\b" << "\\bindex\\b" << "\\buser\\b" << "\\bprimary\\b"
		<< "\\bforeign\\b" << "\\bconstraint\\b" << "\\bby\\b" << "\\bout\\b" << "\\bdelimiter\\b";
}

void Highlighter::MakeDataTypeList(QStringList& dataTypePatterns)
{
	dataTypePatterns << "\\bbool\\b" << "\\bboolean\\b" << "\\bbit\\b" << "\\btinyint\\b" << "\\bsmallint\\b" << "\\bmediumint\\b" 
		<< "\\bint\\b" << "\\binteger\\b" << "\\bbigint\\b" << "\\bfloat\\b" << "\\bdouble\\b" << "\\bdecimal\\b" 
		<< "\\bdec\\b" << "\\bdate\\b" << "\\bdatetime\\b" << "\\btimestamp\\b" << "\\btime\\b" << "\\byear\\b" 
		<< "\\bchar\\b" << "\\bvarchar\\b" << "\\btext\\b" << "\\benum\\b" << "\\bset\\b" << "\\bbinary\\b" 
		<< "\\bvarbinary\\b" << "\\btinyblob\\b" << "\\btinytext\\b" << "\\bblob\\b" <<  "\\bmediumblob\\b" 
		<< "\\bmediumtext\\b" << "\\blongblob\\b" << "\\blongtext\\b" ;
}

 void Highlighter::highlightBlock(const QString &text)
 {
     foreach (HighlightingRule rule, highlightingRules){
         QRegExp expression(rule.pattern);
         int index = text.indexOf(expression);
         while (index >= 0) {
             int length = expression.matchedLength();
             setFormat(index, length, rule.format);
             index = text.indexOf(expression, index + length);
         }
     }

     setCurrentBlockState(0);
	 
     int startIndex = 0;
     if (previousBlockState() != 1)
         startIndex = text.indexOf(commentStartExpression);
	 
     while (startIndex >= 0) {
         int endIndex = text.indexOf(commentEndExpression, startIndex);
         int commentLength;
         if (endIndex == -1) {
             setCurrentBlockState(1);
             commentLength = text.length() - startIndex;
         } else {
             commentLength = endIndex - startIndex
				 + commentEndExpression.matchedLength();
         }
         setFormat(startIndex, commentLength, multiLineCommentFormat);
         startIndex = text.indexOf(commentStartExpression, startIndex + commentLength);
     }
 }
